#! /usr/bin/env python3

import numpy



# Parameters...
initial = numpy.array([0.5, 0.5])
data = numpy.array([[0.6, 0.3],
                    [0.4, 0.7]]) # [observed, latent]
smooth = numpy.array([[0.8, 0.1],
                      [0.2, 0.9]]) # [next, prev]



# Observation...
see = [1, 0, 1]



# Seen...
seen = numpy.zeros((len(see), 2)) # [node, state]
for n, state in enumerate(see):
  seen[n, :] = data[state,:]

print('Seen:')
print(seen)
print()



# Forwards...
forwards = numpy.zeros((len(see), 2)) # [node, state]

forwards[0,:] = initial

for dest in range(1, len(see)):
  mult = smooth * forwards[None, dest-1,:] * seen[None, dest-1, :]
  forwards[dest,:] = mult.max(axis=1)


print('Fowards:')
print(forwards)
print()



# Backwards...
backwards = numpy.zeros((len(see), 2)) # [node, state]

backwards[-1,:] = 1

for dest in range(len(see)-2, -1, -1):
  mult = smooth * backwards[dest+1,:, None] * seen[dest+1, :, None]
  backwards[dest,:] = mult.max(axis=0)


print('Backwards:')
print(backwards)
print()



# Beliefs...
belief = forwards * backwards * seen


print('Belief:')
print(belief)
print()
